/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.hwmca.p.sa;

import com.ibm.hwmca.base.util.BaseFileControl;
import com.ibm.hwmca.fw.HException;
import com.ibm.hwmca.fw.managed.HMC;
import com.ibm.hwmca.fw.pa.problem.Problem;
import com.ibm.hwmca.fw.pa.problem.ProblemDataSetAdditionHandler;
import com.ibm.hwmca.fw.pa.problem.ProblemManager;
import com.ibm.hwmca.fw.schedops.HMCScheduler;
import com.ibm.hwmca.fw.schedops.Schedule;
import com.ibm.hwmca.fw.schedops.ScheduledOperation;
import com.ibm.hwmca.fw.util.Trace;
import com.ibm.hwmca.p.pa.problem.PIProblem;
import com.ibm.hwmca.p.sa.ESAXmitServiceInfoSchedulable;
import com.ibm.hwmca.p.sa.ServiceAgentAttr;
import com.ibm.hwmca.p.sa.ServiceAgentUtils;
import com.ibm.hwmca.xfw.pa.util.ProblemDataDescriptor;
import java.io.BufferedInputStream;
import java.io.BufferedOutputStream;
import java.io.File;
import java.io.FileOutputStream;
import java.text.SimpleDateFormat;
import java.util.Date;
import java.util.Enumeration;
import java.util.List;
import java.util.Locale;
import java.util.zip.ZipEntry;
import java.util.zip.ZipFile;

public class PIProblemChangeHandler
implements ProblemDataSetAdditionHandler,
ServiceAgentAttr {
    private static final String TRACE_MASKT = "ESA    T";
    private static final String TRACE_MASKF = "ESA    F";
    private static final String TRACE_MASKD = "ESA    D";
    private static final String CLASS_NAME = "[PIProblemChangeHandler] ";

    /*
     * WARNING - void declaration
     */
    public void handleDataSetAddition(Problem problem) throws HException {
        block27: {
            Trace.trace(TRACE_MASKF, "[PIProblemChangeHandler] handleDataSetAddition");
            if (problem instanceof PIProblem) {
                PIProblem theProblem = (PIProblem)problem;
                Trace.trace(TRACE_MASKF, "[PIProblemChangeHandler] problemNumber: " + theProblem.getProblemNumber());
                ServiceAgentAttr.ESAreportingMachInfo rep = ServiceAgentUtils.getReportingMachineInfo(theProblem);
                boolean RSFSetting = ServiceAgentUtils.ESACheckRSF(rep.machType, rep.machModel, rep.machSerial);
                if (RSFSetting) {
                    List dList = theProblem.getProblemDataSet();
                    if (dList != null) {
                        boolean updatePM = false;
                        int i = 0;
                        while (i < dList.size()) {
                            ProblemDataDescriptor dd = (ProblemDataDescriptor)dList.get(i);
                            if (dd != null) {
                                Trace.trace(TRACE_MASKF, "[PIProblemChangeHandler]                name: " + dd.getName());
                                Trace.trace(TRACE_MASKF, "[PIProblemChangeHandler]        fileLocation: " + dd.getFileLocation());
                                Trace.trace(TRACE_MASKF, "[PIProblemChangeHandler]                type: " + dd.getType());
                                Trace.trace(TRACE_MASKF, "[PIProblemChangeHandler]             isInZip: " + dd.isInZip());
                                Trace.trace(TRACE_MASKF, "[PIProblemChangeHandler] isCallHomeCandidate: " + dd.isCallHomeCandidate());
                                Trace.trace(TRACE_MASKF, "[PIProblemChangeHandler]        isCalledHome: " + dd.isCalledHome());
                                if (dd.isCallHomeCandidate()) {
                                    File ddFile;
                                    dd.setCallHomeCandidate(false);
                                    updatePM = true;
                                    String fileLocation = "";
                                    Trace.trace(TRACE_MASKF, "[PIProblemChangeHandler] Processing name: " + dd.getName());
                                    if (dd.isInZip() && !dd.getType().equals("INIT_CALL_HOME_DATA_SET")) {
                                        Trace.trace(TRACE_MASKF, "[PIProblemChangeHandler]      in zipFile: " + dd.getFileLocation());
                                        try {
                                            BufferedOutputStream dest = null;
                                            BufferedInputStream is = null;
                                            ZipFile zipfile = new ZipFile(dd.getFileLocation());
                                            Enumeration<? extends ZipEntry> e = zipfile.entries();
                                            while (e.hasMoreElements()) {
                                                int count;
                                                ZipEntry entry = e.nextElement();
                                                Trace.trace(TRACE_MASKF, "[PIProblemChangeHandler] filename: " + entry.getName());
                                                if (!dd.getName().endsWith(entry.getName())) continue;
                                                Trace.trace(TRACE_MASKF, "[PIProblemChangeHandler] extract filename: " + entry.getName());
                                                String problemNumber = new Integer(theProblem.getProblemNumber()).toString();
                                                fileLocation = BaseFileControl.getFilePath("zipdir") + "vr/" + problemNumber + "/" + entry.getName();
                                                Trace.trace(TRACE_MASKF, "[PIProblemChangeHandler] fileLocation: " + fileLocation);
                                                is = new BufferedInputStream(zipfile.getInputStream(entry));
                                                byte[] data = new byte[4096];
                                                FileOutputStream fos = new FileOutputStream(fileLocation);
                                                dest = new BufferedOutputStream(fos, 4096);
                                                while ((count = is.read(data, 0, 4096)) != -1) {
                                                    void var16_19;
                                                    dest.write(data, 0, (int)var16_19);
                                                }
                                                dest.flush();
                                                dest.close();
                                                is.close();
                                                break;
                                            }
                                        }
                                        catch (Exception e) {
                                            Trace.trace(TRACE_MASKF, "[PIProblemChangeHandler] ZipFile exception");
                                            Trace.trace(TRACE_MASKF, e);
                                        }
                                    } else {
                                        fileLocation = dd.getFileLocation();
                                    }
                                    if ((ddFile = new File(fileLocation)) != null) {
                                        if (ddFile.length() > 0L) {
                                            Integer iProblemNumber = new Integer(theProblem.getProblemNumber());
                                            String problemNumber = iProblemNumber.toString();
                                            int rc = ServiceAgentUtils.ESASendEEDRequest(dd.getType(), rep.machType, rep.machModel, rep.machSerial, problemNumber, theProblem.getPMH(), ddFile, theProblem.getUniqueKey(), "ESA.xmit.service");
                                            if (dd.getType().equals("END_OF_CALL")) {
                                                Trace.trace(TRACE_MASKF, "[PIProblemChangeHandler] Schedule VPD Xmit");
                                                this.scheduleXmitVPD(rep.machType, rep.machModel, rep.machSerial);
                                            }
                                        } else {
                                            Trace.trace(TRACE_MASKF, "[PIProblemChangeHandler] ddFile.length was zero");
                                        }
                                    } else {
                                        Trace.trace(TRACE_MASKF, "[PIProblemChangeHandler] ddFile was null");
                                    }
                                }
                            } else {
                                Trace.trace(TRACE_MASKF, "[PIProblemChangeHandler] dd was null");
                            }
                            ++i;
                        }
                        if (updatePM) {
                            try {
                                ProblemManager pm = ProblemManager.getProblemManager();
                                if (pm != null) {
                                    pm.changed(theProblem);
                                    break block27;
                                }
                                Trace.trace(TRACE_MASKF, "[PIProblemChangeHandler] pm was null");
                            }
                            catch (Exception e) {}
                        } else {
                            Trace.trace(TRACE_MASKF, "[PIProblemChangeHandler] no updates required");
                        }
                    } else {
                        Trace.trace(TRACE_MASKF, "[PIProblemChangeHandler] dList was null");
                    }
                } else {
                    Trace.trace(TRACE_MASKF, "[PIProblemChangeHandler] RSF not enabled: " + RSFSetting);
                }
            } else {
                Trace.trace(TRACE_MASKF, "[PIProblemChangeHandler] not a PIProblem");
            }
        }
    }

    private void scheduleXmitVPD(String machType, String machModel, String machSerial) {
        Trace.trace(TRACE_MASKF, "[PIProblemChangeHandler] --> scheduleXmitVPD");
        String sParm = "XmitVPD " + machType + " " + machModel + " " + machSerial;
        Trace.trace(TRACE_MASKF, "[PIProblemChangeHandler] ScheduledOperation options: " + sParm);
        try {
            HMCScheduler scheduler = HMCScheduler.getHMCScheduler();
            ESAXmitServiceInfoSchedulable operation = new ESAXmitServiceInfoSchedulable();
            HMC target = HMC.getHMC();
            List listOfScheduledOps = scheduler.getScheduledOperations(target, operation);
            boolean sendit = true;
            if (listOfScheduledOps != null) {
                int ix = 0;
                while (ix < listOfScheduledOps.size()) {
                    ScheduledOperation so = (ScheduledOperation)listOfScheduledOps.get(ix);
                    String xmitParms = (String)so.getOperationParameters();
                    if (xmitParms != null && xmitParms.equals(sParm)) {
                        Trace.trace(TRACE_MASKF, "[PIProblemChangeHandler] Xmit VPD already scheduled: " + sParm);
                        sendit = false;
                        break;
                    }
                    ++ix;
                }
            }
            if (sendit) {
                Trace.trace(TRACE_MASKF, "[PIProblemChangeHandler] Schedule Xmit VPD: " + sParm);
                SimpleDateFormat df = new SimpleDateFormat("yyyy-MM-dd HH:mm:ss", Locale.US);
                String datetime = "";
                Date date = new Date();
                datetime = df.format(date);
                Trace.trace(TRACE_MASKF, "[PIProblemChangeHandler] current datetime: " + datetime);
                date.setTime(date.getTime() + 86400000L);
                datetime = df.format(date);
                Trace.trace(TRACE_MASKF, "[PIProblemChangeHandler] scheduled datetime: " + datetime);
                Schedule schedule = new Schedule(date, 1200000L, 1L, 0L);
                ESAXmitServiceInfoSchedulable newOperation = new ESAXmitServiceInfoSchedulable();
                ScheduledOperation schedop = new ScheduledOperation(target, newOperation, schedule, sParm);
                target.getScheduler().addScheduledOperation(schedop);
            }
        }
        catch (Throwable t) {
            Trace.trace(TRACE_MASKF, "[PIProblemChangeHandler] caught exception:");
            Trace.trace(TRACE_MASKF, t);
        }
        Trace.trace(TRACE_MASKT, "[PIProblemChangeHandler] <-- scheduleXmitVPD");
    }
}

